
unit head;
interface
type

// 1.  Find ROCKEY2 dongles attached to the computer
 TRY2_Find=function():integer;stdcall;
//return value
// <0	Error code
// =0	No ROCKEY2 dongle is attached
// >0	The number of attached ROCKEY2 dongle(s)

// ====================================================================

// 2. Open specified ROCKEY2 dongle
TRY2_Open=function(mode:integer; uid :cardinal; var hid :cardinal):integer;stdcall;
// input:
// mode----This parameter indicates the way to open the dongle
// mode = 0, open the first found ROCKEY2 dongle
// mode > 0, open the dongle according to the UID. The mode value is the dongle number,
//           for example: uid=12345678, mode=2, this means it will open the second dongle with UID 12345678
// mode = -1, open the dongle according to the HID, and *hid can not be 0
//We defined two MACROs:
// AUTO_MODE    =	0
// HID_MODE     =	-1
// uid---UserID,You need to specify the dongle UID and this UID is generated with RY2_GenUID
// hid---Hardware ID,Open dongle with HID of *hid
// The dongle HID will be returned to *hid regardless of how the dongle was opened.
// return vaule:
// >=0	Success. The opened dongle handle is returned.
// < 0	Error code. Please refer to the later

// ====================================================================
// 3. Close specified ROCKEY2 dongle
  TRY2_Close=procedure(handle:integer); stdcall;
// Input:
// handle---ROCKEY2 dongle handle. It is the handle returned from RY2_Open
// Return:
// Error code. Please refer to the later
// ====================================================================

// 4.Generate User ID(UID)
 TRY2_GenUID=function(handle:integer; var uid : cardinal; seed: pchar; isProtect:integer):integer;stdcall;
// input:
// handle---Dongle handle. It is the handle returned from RY2_Open.
// uid---Output parameter. The generated UID.
// seed---Seed to generate UID. It is a character string with the maximum length of 64 bytes
// isProtect---Sets write protection. 0=dongle not write protected, 1=dongle write protected.
// ROCKEY2_DISABLE_WRITE_PROTECT     =	0
// ROCKEY2_ENSABLE_WRITE_PROTECT	=1
// Return:
// Error code. Please refer to the later

// ====================================================================
// 5. Read dongle content
TRY2_Read=function(handle:integer;block_index : integer;  buffer512:pchar):integer;stdcall;
// input:
// handle---Dongle handle. It is the handle returned from RY2_Open.
// block_index---Block index. Specify the block to read. The value range is 0-4.
// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
// Return:
// Error code. Please refer to the later

// ====================================================================
// 6. Write to ROCKEY2 dongle
 TRY2_Write=function(handle:integer;block_index : integer;  buffer512:pchar):integer;stdcall;
// input:
// handle---Dongle handle. It is the handle returned from RY2_Open
// block_index---Block index. Specify the block to read. The value range is 0-4.
// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
// Return:
// Error code. Please refer to the later


var

RY2_Find : TRY2_Find;
RY2_Open : TRY2_Open;
RY2_Close : TRY2_Close;
RY2_GenUID : TRY2_GenUID;
RY2_Read  : TRY2_Read ;
RY2_Write : TRY2_Write;


const
//
AUTO_MODE :integer=0;
HID_MODE :integer=-1;
ROCKEY2_DISABLE_WRITE_PROTECT:integer =0;
ROCKEY2_ENABLE_WRITE_PROTECT:integer  =1;

// Error code ===========================================================

// Success
 RY2ERR_SUCCESS								:integer=0;

// Specified dongle is not found (parameter error)
 RY2ERR_NO_SUCH_DEVICE							:integer = $A0100001 ;

// Need to call RY2_Open first to open the dongle, then call this function (operation error)
 RY2ERR_NOT_OPENED_DEVICE						:integer = $A0100002;

//Wrong UID(parameter error)
 RY2ERR_WRONG_UID								:integer = $A0100003 ;

// Block index error (parameter error)
 RY2ERR_WRONG_INDEX								:integer = $A0100004  ;

// Seed character string is longer than 64 bytes when calling GenUID (parameter error)
 RY2ERR_TOO_LONG_SEED							:integer = $A0100005    ;

//Tried to write to write-protected dongle(operation error)
 RY2ERR_WRITE_PROTECT							:integer = $A0100006   ;

// Open device error (Windows error)
 RY2ERR_OPEN_DEVICE								:integer = $A0100007  ;

// Read record error(Windows error)
 RY2ERR_READ_REPORT								:integer = $A0100008  ;

// Write record error(Windows error)
 RY2ERR_WRITE_REPORT								:integer = $A0100009  ;

// Internal error (Windows error)
 RY2ERR_SETUP_DI_GET_DEVICE_INTERFACE_DETAIL		:integer = $A010000A                 ;

//Internal error (Windows error)
 RY2ERR_GET_ATTRIBUTES							:integer = $A010000B   ;

// Internal error (Windows error)
 RY2ERR_GET_PREPARSED_DATA						:integer = $A010000C  ;

// Internal error (Windows error)
 RY2ERR_GETCAPS									:integer = $A010000D  ;

// Internal error (Windows error)
 RY2ERR_FREE_PREPARSED_DATA						:integer = $A010000E       ;

// Internal error (Windows error)
 RY2ERR_FLUSH_QUEUE								:integer = $A010000F ;

// Internal error (Windows error)
 RY2ERR_SETUP_DI_CLASS_DEVS						:integer = $A0100010   ;

// Internal error (Windows error)
 RY2ERR_GET_SERIAL								:integer = $A0100011 ;

// Internal error
 RY2ERR_TOO_LONG_DEVICE_DETAIL					:integer = $A0100012        ;

//Unknown device(hardware error)
 RY2ERR_WRONG_REPORT_LENGTH						:integer = $A0100013  ;

//Verification error(hardware error)
 RY2ERR_VERIFY									:integer = $A0100014 ;

// Unknown error(hardware error)
 RY2ERR_UNKNOWN_ERROR							:integer = $A010FFFF   ;
implementation

end.
